' VB Script to show how to use the ADSearch function within the same script     '
'                                                                               '
' Version 1.00 - Alain Lissoir                                                  '
' Compaq Computer Corporation - Professional Services - Belgium -               '
'                                                                               '
' Any comments or questions:                     EMail:alain.lissoir@compaq.com '

Option Explicit

Dim objResultList
Dim objResult
Dim intColumnPosition

Set objResultList = ADSearch ("DefaultNamingContext", _
                              "(|(objectClass=domainDNS)(objectClass=organizationalUnit))", _
                              "name,distinguishedName", _
                              "subTree", _
                              False)
WScript.Echo
WScript.Echo "Number of record found is " & objResultList.Item ("RecordCount")
WScript.Echo "Number of elements in the Scripting Dictionary object is " & objResultList.Count

For Each objResult in objResultList
    intColumnPosition = InStr (objResult, ":")
    If intColumnPosition Then
       Wscript.Echo Mid (objResult, 1, intColumnPosition - 1) & "=>" & _
                         objResultList.Item (objResult)
    End If
Next

' --------------------------------------------------------------------------------------------------------
Function ADSearch _
         (strNamingContextSearch, strFilterSearch, strAttribsToReturnSearch, strDepthSearch, boolEcho)

        Dim objDictionary

        Dim objRoot
        Dim strNamingContext
        Dim objNamingContext

        Dim objADOConnnection
        Dim objCommand
        Dim objRecordSet

        Dim strADsPathSearch

        Dim intIndice

        Set objDictionary = CreateObject ("Scripting.Dictionary")

        Set objADOConnnection = CreateObject("ADODB.Connection")
        objADOConnnection.Provider = "ADsDSOObject"
        objADOConnnection.Open "Active Directory Provider"

        Set objCommand = CreateObject("ADODB.Command")
        Set objCommand.ActiveConnection = objADOConnnection

        If Ucase (Mid (strNamingContextSearch, 1, 7)) = "LDAP://" Or _
           Ucase (Mid (strNamingContextSearch, 1, 5)) = "GC://" Then

           Set objNamingContext = GetObject(strNamingContextSearch)
        Else
           Set objRoot = GetObject("LDAP://RootDSE")
           strNamingContext = objRoot.Get(strNamingContextSearch)
           Set objRoot = Nothing

           ' Search is executed in LDAP: namespace.
           ' Search in Global Catalog (GC:) instead of classical directory (LDAP:) can
           ' increase search speed but be aware if properties searched are not
           ' replicated in GC. (Such as data in the schema or some context properties)
           Set objNamingContext = GetObject("LDAP://" & strNamingContext)
        End If

        strADsPathSearch = "<" & objNamingContext.ADsPath & ">"

        objCommand.CommandText = strADsPathSearch & ";" & _
                                 strFilterSearch & ";" & _
                                 strAttribsToReturnSearch & ";" & _
                                 strDepthSearch
        If boolEcho Then Wscript.Echo objCommand.CommandText

        If boolEcho Then WScript.Echo "Searching ..." & vbCRLF
        Set objRecordSet = objCommand.Execute

        objDictionary.Add "RecordCount", objRecordSet.RecordCount

        While Not objRecordSet.EOF
            For intIndice = 0 To objRecordSet.Fields.Count - 1

                If boolEcho Then
                   WScript.Echo "(" & objRecordSet.AbsolutePosition & intIndice & ") " & _
                                      objRecordSet.Fields(intIndice).Name & " = " & _
                                      objRecordSet.Fields(intIndice).Value
                End If

                objDictionary.Add objRecordSet.Fields(intIndice).Name & ":" & _
                                  objRecordSet.AbsolutePosition & intIndice, _
                                  objRecordSet.Fields(intIndice).Value
            Next

            If boolEcho Then WScript.Echo

            objRecordSet.MoveNext
        Wend

        If boolEcho Then Wscript.Echo objRecordSet.RecordCount & " record(s) found."

        Set ADSearch = objDictionary

        Set objNamingContext = Nothing

        WScript.DisconnectObject objCommand
        Set objCommand = Nothing

        WScript.DisconnectObject objADOConnnection
        Set objADOConnnection = Nothing

        WScript.DisconnectObject objDictionary
        Set objDictionary = Nothing

End Function